********************************************************************************************************************;
*** Informed consent (V1.0) part2                                                                                ***;
***Programmer: Haikun Bao                                                                                        ***;
***Created on: 01/22/2018                                                                                        ***;
********************************************************************************************************************;

********************************************************************************************************************;
***Specify various file pathes                                                                                   ***;
********************************************************************************************************************;
%let path1=H:\DOC\Informed consent\SAS pack ICD10; /*ACCESS data file of reviewed IC forms with abstraction tool,
                                                                     raw data files path, must be changed*/
%let path2=H:\DOC\Informed consent\SAS pack ICD10\data; /*permanent output files path, must be changed*/
LIBNAME PF "&path2";

***import ACCESS data file to SAS;
LIBNAME Database ACCESS "&path1.\IC_forms.accdb"; /*the ACCESS data file name 
                                                  "IC_forms.accdb" must be changed*/
DATA RawData;
  SET Database.tbl_AbstractionTool;
RUN;

***calculate scores for each IC forms;
data IC_scores(drop=a);
   set RawData;
   length a hospID $ 25;
   a=study_id;
   hospId=substr(left(a),1,2);
   q1=(description__name="1");
   q2=(description__name___typed="1");
   q3=(description__Steps="1");
   q4=(description__Steps___typed="1");
   q5=(Rationale="2");
   q11=(Rationale="1");
   q6=(benefit="1");
   q7=(risk_probability___quant="1");
   q8=(risk_probability___qual="1");
   q9=(alternative="1");
      if year(datepart(date_of_patient_signature)) in (9999,4444,1111) then date_of_patient_signature=.;
      if year(datepart(date_of_procedure)) in (9999,4444,1111) then date_of_procedure=.;
      if missing(date_of_procedure) or missing(date_of_patient_signature) then Timing=0;
      else if datepart(date_of_procedure)<=datepart(date_of_patient_signature) then Timing=0;
      else timing=1;
      if timing=0 and opt_out=1 then timing=1;  
   q10=(timing=1);

   IC_score=q1*2+q2*1+q3*2+q4*1+q5*2+q11*1+q6*2+q7*2+q8*1+q9*2+q10*5;
   score_ge5=(IC_score>=5);
   score_ge10=(IC_score>=10);
run;

***get hospital level scores;
proc sql;
   create table hospital_scores as select distinct hospId, mean(IC_score) as mean_score, 100*mean(score_ge5) as perct5_score, 
                                          100*mean(score_ge10) as perct10_score  from IC_scores group by hospId;
quit;

data pf.hospital_scores;
   set hospital_scores;
   label hospId="Hospital ID"
         mean_score="Mean of IC scores"
		 perct5_score="Percentage of IC scores greater or equal to 5 (%)"
		 perct10_score="Percentage of IC scores greater or equal to 10 (%)"
   ;
run;

proc datasets nodetails;
  delete RawData IC_scores hospital_scores;
run;
